/*
 * Decompiled with CFR 0.152.
 */
package com.dao.use_case;

import com.android.invoice.domain.AInvoiceType;
import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.model.res_invoice.AResInvoiceDto;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoice;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceDtl;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceProcess;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class OnlineFactureUseCase {
    private final DbConnection dbConnection;
    private final InsertAInvoice insertAInvoice;
    private final InsertAInvoiceDtl insertAInvoiceDtl;
    private final InsertAInvoiceProcess insertAInvoiceProcess;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public void convertToOnlineFacture(AResInvoiceDto resInvoice, SettingLoader settingLoader) {
        AInvoiceDto aInvoiceDto = this.mapResInvoiceToAInvoice(resInvoice);
        aInvoiceDto.setId(Long.valueOf(this.insertAInvoice.invoke(aInvoiceDto)));
        this.insertAInvoiceDtl.invoke(aInvoiceDto, settingLoader);
        this.insertAInvoiceProcess.invoke(aInvoiceDto);
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        if (resInvoice.isIsonlinefacture() && resInvoice.isIstakeaway()) {
            this.scheduler.schedule(() -> this.deleteTakeawayResFacture(jdbc), 10L, TimeUnit.SECONDS);
        } else {
            this.deleteResFactureByFacCode(resInvoice.getId());
        }
    }

    private void deleteTakeawayResFacture(TncJdbc jdbc) {
        String sql = "SELECT * INTO #tmp_table FROM (SELECT F_Code FROM Res_Facture rf \nLEFT JOIN RMTempFacture rm ON rm.FactId = rf.F_Code\nWHERE rm.FactId IS NULL AND IS_OnlineFacture = 1 AND Outer_Ord = 1) A \n\nDELETE FROM Res_Facture WHERE F_Code IN (SELECT * FROM #tmp_table) \nDELETE FROM Res_Fac_List WHERE F_Code IN (SELECT * FROM #tmp_table) \n\ndrop table #tmp_table";
        jdbc.execute(sql);
    }

    private void deleteResFactureByFacCode(Long facCode) {
        String sql = "DELETE FROM Res_Facture WHERE F_Code = '" + facCode + "' \nDELETE FROM Res_Fac_List WHERE F_Code = '" + facCode + "'";
        this.dbConnection.getJdbcTemplate().execute(sql);
    }

    private AInvoiceDto mapResInvoiceToAInvoice(AResInvoiceDto resInvoice) {
        String sql = "select * from Res_Facture where F_Code = '" + resInvoice.getId() + "'";
        AInvoiceDto.AInvoiceDtoBuilder aInvoiceDto = AInvoiceDto.builder();
        SqlRowSet rowSet = this.dbConnection.getJdbcTemplate().queryForRowSet(sql);
        while (rowSet.next()) {
            String facDateTime = Objects.requireNonNull(rowSet.getString("F_Date")).replace("00:00:00.0", rowSet.getString("F_Time") + ":00.000");
            aInvoiceDto.aInvoiceTypeName(AInvoiceType.ORDER_SALE).id(resInvoice.getId()).kind(5).invoiceDate(facDateTime).partyCode(rowSet.getString("C_Code")).description(rowSet.getString("F_Comment")).discountPrice(rowSet.getDouble("F_Takhfif")).settlementDate(rowSet.getString("F_Date")).cashAmount(rowSet.getDouble("F_Naghd")).creditAmount(rowSet.getDouble("F_Nesieh")).posAmount(rowSet.getDouble("F_Pos")).accountHeading(rowSet.getString("Pos_Code")).taxSum(rowSet.getDouble("Sum_Levy"));
        }
        sql = "SELECT * FROM Res_Fac_List WHERE F_Code = '" + resInvoice.getId() + "'";
        ArrayList aInvoiceDtlList = new ArrayList();
        this.dbConnection.getJdbcTemplate().query(sql, res -> aInvoiceDtlList.add(AInvoiceDtlDto.builder().productCode(res.getString("A_Code")).amount(res.getDouble("FL_Few")).thirdAmount(Double.valueOf(0.0)).price(res.getDouble("FL_Price")).description(res.getString("FL_Comment")).unitCode(res.getString("Unit_Code")).perRowDiscountAmount(Double.valueOf(res.getDouble("TakhfifSatrir"))).perRowDiscountPercent(Double.valueOf(res.getDouble("SumTakhfifSatri_P"))).box(res.getDouble("FewKarton")).pack(res.getDouble("FewBasteh")).rowIndex(Integer.valueOf(res.getInt("FL_Index"))).usingBoxPrice(Boolean.valueOf(false)).build()));
        aInvoiceDto.dtlDto(aInvoiceDtlList);
        return aInvoiceDto.build();
    }

    public OnlineFactureUseCase(DbConnection dbConnection, InsertAInvoice insertAInvoice, InsertAInvoiceDtl insertAInvoiceDtl, InsertAInvoiceProcess insertAInvoiceProcess) {
        this.dbConnection = dbConnection;
        this.insertAInvoice = insertAInvoice;
        this.insertAInvoiceDtl = insertAInvoiceDtl;
        this.insertAInvoiceProcess = insertAInvoiceProcess;
    }
}

